package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.RequerimientoOS2;
import com.ejie.ab04b.model.TareaOS2;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0447s00DaoImpl generated by UDA, 31-may-2017 9:30:50.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class RequerimientoOS2DaoImpl implements RequerimientoOS2Dao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_047 IDTAREA047, t1.MOTIVO_047 MOTIVO047, t1.DESC_OTROS_ES_047 DESCOTROSES047, t1.DESC_OTROS_EU_047 DESCOTROSEU047 FROM AB0447S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RequerimientoOS2> rwMap = new RowMapper<RequerimientoOS2>() {
		public RequerimientoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new RequerimientoOS2(new TareaOS2(
					resultSet.getLong("IDTAREA047")),
					resultSet.getString("MOTIVO047"),
					resultSet.getString("DESCOTROSES047"),
					resultSet.getString("DESCOTROSEU047"));
		}
	};

	private RowMapper<RequerimientoOS2> rwMapPK = new RowMapper<RequerimientoOS2>() {
		public RequerimientoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new RequerimientoOS2(new TareaOS2(
					resultSet.getLong("IDTAREA047")),
					resultSet.getString("MOTIVO047"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the requerimiento OS 2
	 */
	public RequerimientoOS2 add(RequerimientoOS2 ab0447s00) {
		String query = "INSERT INTO AB0447S00 (ID_TAREA_047, MOTIVO_047, DESC_OTROS_ES_047, DESC_OTROS_EU_047) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query,
				ab0447s00.getTareaOS2().getIdTarea093(),
				ab0447s00.getMotivo047(), ab0447s00.getDescOtrosEs047(),
				ab0447s00.getDescOtrosEu047());
		return ab0447s00;
	}

	/**
	 * Updates a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the requerimiento OS 2
	 */
	public RequerimientoOS2 update(RequerimientoOS2 ab0447s00) {
		String query = "UPDATE AB0447S00 SET DESC_OTROS_ES_047=?, DESC_OTROS_EU_047=? WHERE ID_TAREA_047=? AND MOTIVO_047=?";
		this.jdbcTemplate.update(query, ab0447s00.getDescOtrosEs047(),
				ab0447s00.getDescOtrosEu047(), ab0447s00.getTareaOS2()
						.getIdTarea093(), ab0447s00.getMotivo047());
		return ab0447s00;
	}

	/**
	 * Finds a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the requerimiento OS 2
	 */
	@Transactional(readOnly = true)
	public RequerimientoOS2 find(RequerimientoOS2 ab0447s00) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS2DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_047 = ?   AND t1.MOTIVO_047 = ? ");

		List<RequerimientoOS2> ab0447s00List = this.jdbcTemplate.query(query
				.toString(), this.rwMap, ab0447s00.getTareaOS2()
				.getIdTarea093(), ab0447s00.getMotivo047());

		return (RequerimientoOS2) DataAccessUtils.uniqueResult(ab0447s00List);
	}

	/**
	 * Removes a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 */
	public void remove(RequerimientoOS2 ab0447s00) {
		String query = "DELETE FROM AB0447S00 WHERE ID_TAREA_047=? AND MOTIVO_047=?";
		this.jdbcTemplate.update(query,
				ab0447s00.getTareaOS2().getIdTarea093(),
				ab0447s00.getMotivo047());
	}

	/**
	 * removePorTarea
	 * 
	 * @param idTarea
	 *            Long
	 */
	@Override
	public void removePorTarea(Long idTarea) {
		String query = "DELETE FROM AB0447S00 WHERE ID_TAREA_047=? ";
		this.jdbcTemplate.update(query, idTarea);
	}

	/**
	 * Finds a list of rows in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto List<Ab0447s00>
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<RequerimientoOS2> findAll(RequerimientoOS2 ab0447s00,
			JQGridRequestDto jqGridRequestDto) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS2DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0447s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<RequerimientoOS2>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0447s00 table using like.
	 * 
	 * ab0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0447s00>
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<RequerimientoOS2> findAllLike(RequerimientoOS2 ab0447s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS2DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0447s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<RequerimientoOS2>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 Long
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RequerimientoOS2 ab0447s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0447S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0447s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0447s00 table using like.
	 * 
	 * ab0447s00 Ab0447s00 startsWith Boolean Long
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(RequerimientoOS2 ab0447s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0447S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0447s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0447s00 selected for rup_table.
	 * 
	 * ab0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0447s00>>
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<RequerimientoOS2>> reorderSelection(
			RequerimientoOS2 ab0447s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS2DaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0447s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, RequerimientoOS2.class,
				filterParamList, "ID_TAREA_047,MOTIVO_047");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RequerimientoOS2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0447s00 searchParams Ab0447s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0447s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<RequerimientoOS2>> search(
			RequerimientoOS2 filterParams, RequerimientoOS2 searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS2DaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, RequerimientoOS2.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ID_TAREA_047,MOTIVO_047");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RequerimientoOS2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filterab0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterab0447s00
	 *            the filterab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(RequerimientoOS2 filterab0447s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TAREA_047 IDTAREA047,t1.MOTIVO_047 MOTIVO047,t1.DESC_OTROS_047 DESCOTROS047 ");
		// FROM
		query.append("FROM AB0447S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0447s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						RequerimientoOS2.class, query, params,
						"ID_TAREA_047,MOTIVO_047");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0447s00 entity.
	 * 
	 * ab0447s00 Ab0447s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RequerimientoOS2 ab0447s00) {

		StringBuilder where = new StringBuilder(
				RequerimientoOS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0447s00 != null && ab0447s00.getTareaOS2() != null
				&& ab0447s00.getTareaOS2().getIdTarea093() != null) {
			where.append(" AND t1.ID_TAREA_047 = ?");
			params.add(ab0447s00.getTareaOS2().getIdTarea093());
		}
		if (ab0447s00 != null && ab0447s00.getMotivo047() != null) {
			where.append(" AND t1.MOTIVO_047 = ?");
			params.add(ab0447s00.getMotivo047());
		}
		if (ab0447s00 != null && ab0447s00.getDescOtrosEs047() != null) {
			where.append(" AND t1.DESC_OTROS_ES_047 = ?");
			params.add(ab0447s00.getDescOtrosEs047());
		}
		if (ab0447s00 != null && ab0447s00.getDescOtrosEu047() != null) {
			where.append(" AND t1.DESC_OTROS_EU_047 = ?");
			params.add(ab0447s00.getDescOtrosEu047());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0447s00 entity.
	 * 
	 * ab0447s00 Ab0447s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(RequerimientoOS2 ab0447s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RequerimientoOS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0447s00 != null && ab0447s00.getTareaOS2() != null
				&& ab0447s00.getTareaOS2().getIdTarea093() != null) {
			where.append(" AND t1.ID_TAREA_047 = ?");
			params.add(ab0447s00.getTareaOS2().getIdTarea093());
		}
		if (ab0447s00 != null && ab0447s00.getMotivo047() != null) {
			where.append(" AND UPPER(t1.MOTIVO_047) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0447s00.getMotivo047().toUpperCase() + "%");
			} else {
				params.add("%" + ab0447s00.getMotivo047().toUpperCase() + "%");
			}
			where.append(" AND t1.MOTIVO_047 IS NOT NULL");
		}
		if (ab0447s00 != null && ab0447s00.getDescOtrosEs047() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_ES_047) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0447s00.getDescOtrosEs047().toUpperCase() + "%");
			} else {
				params.add("%" + ab0447s00.getDescOtrosEs047().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_OTROS_ES_047 IS NOT NULL");
		}
		if (ab0447s00 != null && ab0447s00.getDescOtrosEu047() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_EU_047) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0447s00.getDescOtrosEu047().toUpperCase() + "%");
			} else {
				params.add("%" + ab0447s00.getDescOtrosEu047().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_OTROS_EU_047 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
